define(['angular', 'app', 'formatter'], function (angular, app) {
	'use strict';

	app.controller('NotificationsDetailsController', function ($scope, $state, $stateParams, NotificationsInstanceBuilderService) {


		var service = NotificationsInstanceBuilderService.instance($stateParams.section);
		$scope.formConfig = {
			service : service,
			callbacks: {
				common : function(){
					$state.go($state.current.data.backState, $stateParams);
				}
			},
			allowedActions : {
				save : false,
				delete : true,
				cancel : false,
				ok: true
			}
		};

		$scope.details = angular.copy(service.localGetById($stateParams.id));

		if(!$scope.details) {
			$state.go($state.current.data.backState, $stateParams)	
		}
	});
});